import mongoose from 'mongoose';

const subdivisionSchema = new mongoose.Schema({
  name: {
    type: String,
    required: [true, 'Subdivision name is required'],
    unique: true,
    trim: true
  },
  division: {
    type: mongoose.Schema.Types.ObjectId,
    ref: 'Division',
    required: [true, 'Subdivision must belong to a division']
  }
}, { timestamps: true });

export default mongoose.model('Subdivision', subdivisionSchema);