import mongoose from 'mongoose';

const pointTypeSchema = new mongoose.Schema({
  name: {
    type: String,
    required: [true, 'Type name is required'],
    unique: true,
    trim: true
  },
  icon: {
    type: String, // Now stores URL (e.g., 'https://map-server.whirelab.com/uploads/types/icon-68dbc0c0acf3b9b9aa5758a8.svg')
    required: false,
    trim: true
  }
}, { timestamps: true });

export default mongoose.model('PointType', pointTypeSchema);