# EDM Backend API

Node.js + Express.js backend for the EDM Reference Points Management System.

## Features

- RESTful API for point management
- MongoDB with Mongoose ODM
- Firebase Authentication integration
- Input validation and error handling
- Rate limiting and security headers
- CORS configuration

## Setup

1. **Install dependencies**:
   ```bash
   npm install
   ```

2. **Environment Configuration**:
   ```bash
   cp .env.example .env
   ```
   
   Edit `.env` with your configuration:
   - MongoDB connection string
   - Firebase Admin SDK credentials
   - Port configuration

3. **Firebase Setup**:
   - Create a Firebase project
   - Generate a service account key
   - Add the credentials to your `.env` file

4. **MongoDB Setup**:
   - Install MongoDB locally or use MongoDB Atlas
   - Update the connection string in `.env`

5. **Start the server**:
   ```bash
   # Development
   npm run dev
   
   # Production
   npm start
   ```

## API Endpoints

### Authentication
All endpoints require Firebase JWT token in the Authorization header:
```
Authorization: Bearer <firebase-jwt-token>
```

### Points

- `GET /api/points` - Get all points (with filtering and search)
  - Query params: `type`, `search`, `page`, `limit`
- `GET /api/points/:id` - Get single point
- `POST /api/points` - Create new point
- `PUT /api/points/:id` - Update point
- `DELETE /api/points/:id` - Delete point
- `GET /api/points/meta/types` - Get available point types

### Health Check

- `GET /api/health` - Server and database status

## Data Model

### Point Schema
```javascript
{
  name: String (required, max 100 chars),
  description: String (required, max 500 chars),
  type: String (enum: ['Armazém', 'PTS', 'Sucursal', 'Posto EDM', 'Parceiro']),
  coordinates: {
    latitude: Number (required, -90 to 90),
    longitude: Number (required, -180 to 180)
  },
  createdBy: String (Firebase UID),
  updatedBy: String (Firebase UID),
  createdAt: Date,
  updatedAt: Date
}
```

## Deployment

### Render.com
1. Connect your GitHub repository
2. Set environment variables
3. Deploy with build command: `npm install`
4. Start command: `npm start`

### Railway.app
1. Connect your GitHub repository
2. Set environment variables
3. Railway will auto-detect and deploy

## Security Features

- Helmet.js for security headers
- CORS configuration
- Rate limiting (100 requests per 15 minutes)
- Input validation and sanitization
- Firebase token verification

## Development

```bash
# Install nodemon for development
npm install -g nodemon

# Start with auto-reload
npm run dev
```

The server will start on `http://localhost:5000` by default.